/** This file contains some basic modules related to 
 * prime number generation which are used by the geometric
 * expanders.
 *
 */

#include <stdio.h>
#include <math.h>

int getNextPrime(int k); 
int checkPrime(int n); 
int divides(int i, int j);

void printNK(int q, int d);
int findK(int q, int d) ;
int findN(int q, int d) ;

//-----------Following are functions for generating n and k-----------

void printNK(int q, int d) {
	 int n1, k1;
	 n1 = findN(q, d);
	 k1 = findK(q, d);
	 printf(" n = %d \n", n1);
	 printf(" k = %d \n", k1);
}

int findK(int q, int d) {
	 int answer=0;
	 answer = (((int) pow((double) q, (double) d)) - 1) / (q - 1);
	 return answer;
}

int findN(int q, int d) {
	 int answer=0;
	 answer = (((int) pow((double) q, (double) (d+1))) - 1) / (q - 1);
	 return answer;
}

//-----------Following are functions for primality testing------------

// Function to get the next prime 
int getNextPrime(int k) {
	 int flag = 1;
	 int n = k+2;
	 while (flag) {
		  if (checkPrime(n)) 
			   flag = 0;
		  else 
			   n+=2;
	 }
	 return n;
}

// Function to check whether a number is prime or not
int checkPrime(int n) {
	 int j;
	 //printf("Checking %d", n);
	 for (j=2; j <= floor(sqrt((double)n)); j++) {
		  if (divides(j, n))
			   return 0;
	 }
	 return 1;
}
			   
// Function to check if i divides j
int divides(int i, int j) {
	 return (j == (j/i)*i);
}


