/** This file contains the functions for the generation of random 
 * expander graphs with "n" vertices and degree "d". It utilizes 
 * the randomized class for random number generation.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "Randomizer.hpp"

#define klimit 20

#define seed1 455
#define seed2 456

// Function prototypes :-
void generateRandomBipartileExpander(int, int, int[][klimit]);
void generateRandomExpander(int, int, int subsets[][klimit]); 

static short numberOfCalls = 0;

void generateRandomExpander(int n, int d, int subsets[][klimit]) {
	  generateRandomBipartileExpander(n, d, subsets);
}

// The bipartile construction 
void generateRandomBipartileExpander(int n, int d, int adjacency[][klimit]) {
	 Randomizer r;
	 int list[n+1]; // These emulate the linked list we are using
	 int back[n+1]; // -------------------------------------------
	 int listforj[n+1], backforj[n+1];
	 int m, mover, flag, count;
	 int remainingNumber, matchedvertex;
	 
	 numberOfCalls++;
	 
	 for (int i=1; i<=d; i++) {
		  
		  for (int j=0; j<=n; j++) {
			   list[j] = j+1;
			   back[j] = j-1;
		  }
		  
		  srand(time(NULL));
		  for (int j=0; j<n; j++) {
			   for (int k=0; k<=n; k++) {
					listforj[k] = list[k];
					backforj[k] = back[k];
			   }

			   // Exclude the members of the list which have already 
			   // been connected to vertex j
			   remainingNumber = n-j;
			   for (int k=0; k<i-1; k++) {
					matchedvertex = adjacency[j][k];
					if (listforj[matchedvertex+1] != -10) {
						 remainingNumber--;
						 listforj[backforj[matchedvertex+1]] = listforj[matchedvertex+1];
						 if (listforj[matchedvertex + 1] != n+1) {
							  backforj[listforj[matchedvertex+1]] = backforj[matchedvertex+1];
						 }
					}
			   }
			   
			   // Check if number of available vertices is 0
			   if (remainingNumber == 0) {
					// If yes, announce failure..
					for (int j1=0; j1<=n; j1++) {
						 list[j1] = j1+1;
						 back[j1] = j1-1;
					}
					
					numberOfCalls++;
					srand(time(NULL));
					j=-1; // Will take us back to the generation of the first edge
			   } else {
					// If not, Invoke randomizer..
					r.init(rand()*i*numberOfCalls, remainingNumber);

					m = r.nextNumber();
					mover = 0;
					for (int k=0; k<=m; k++) {
						 mover = listforj[mover];
					}
					// Now mover is number at the mth position in the reamining list.

					adjacency[j][i-1] = mover-1;
					if (back[mover] != -1) {
						 list[back[mover]] = list[mover];
					}
					if (list[mover] != n+1) {
						 back[list[mover]] = back[mover];
					}
					list[mover] = back[mover] = -10; // meaning that the element doesn't exist !		  
			   }
		  }
	 }
	 return;
}

