#!/usr/bin/perl -w

use strict;

my $DISASSEMBLER_HOST = "handel";
my $tvc_log_file      = "tvc.log";
my $tvppc_log_file    = "tvppc.log";
my $output_log_file   = "run_tv.log";

my $source_file = shift;
my $executable_file = shift;
my $node_name = shift;
my $ret_val = 0;
defined $source_file and defined $executable_file and defined $node_name or 
die "Usage: $0 <source_file> <executable_file> <node_name>";

my $disassmebler_file = "$node_name.dis";
my $tvppc_file        = "a_stdout0";
my $tvc_file          = "c_stdout0";

-e $source_file and  -e $executable_file and -e $executable_file or 
	die "ERROR: One of the input files does not exist.\n";


print "Running TVPPC...\n";
$ret_val = system ("tvppc $disassmebler_file -d $executable_file -n $node_name -u $source_file -cvc  >  $tvppc_log_file 2>& 1");
if ($ret_val !=0 ) {die "ERROR : tvppc did not run correctly. Please send example file raya.leviathan\@weizmann\.ac\.il \n";}
if (not -e $tvppc_file) {
    die "ERROR: TVPPC file was not created!";
}

print "Running TVC...\n";
$ret_val =system ("tvc $source_file -dump $executable_file -n $node_name -u $source_file > $tvc_log_file 2>& 1");
if ($ret_val != 0) { die "ERROR : tvc did not run correctly. Please send example file to raya.leviathan\@weizmann\.ac\.il \n";}
if (not -e $tvc_file) {
    die "ERROR: TVC file was not created!";
}

print "Running CVC...\n";
if (-e $output_log_file) {
    unlink $output_log_file;
}

system ("seperate_query_files.pl $tvppc_file $tvc_file \|tee $output_log_file");
#system ("seperate_query_files.pl $tvppc_file $tvc_file");











