function curveOut = DeletePoint(curveIn)

% delete point
curveOut = curveIn(1:end-1, 1:2);

% window must be cleared before calling this function to redraw correctly
numPts = size(curveOut, 1);
if numPts > 1    
   line( ...       
   curveOut(1:numPts,1), ...       
   curveOut(1:numPts,2), ...       
   'Color','b', ...       
   'MarkerSize', 6, ...       
   'EraseMode','background', ...       
   'Marker', 'square'); 
elseif numPts == 1   
   line( ...       
   curveOut(1,1), ...       
   curveOut(1,2), ...       
   'Color','b', ...       
   'MarkerSize', 6, ...       
   'EraseMode','background', ...       
   'Marker', 'square'); 
end; 
