function newCurve = addPoints(curve)  

mouseCoord = get(gca, 'CurrentPoint');
newPt = mouseCoord(1, 1:2); 
prevPt = curve(end, 1:2);    
diff = newPt - prevPt;    
% check distance
if (norm(diff) < 1)
    % do nothing
    newCurve = curve;
    return;
else
    % normalize to simluate uniform parametrization    
    newPt = prevPt + diff/norm(diff); 
end
% append point 
newCurve = [curve; newPt]; 
numPts = size(newCurve, 1); 
if numPts > 1    
   line( ...       
   newCurve(numPts-1:numPts,1), ...       
   newCurve(numPts-1:numPts,2), ...       
   'Color','b', ...       
   'EraseMode','none', ...       
   'MarkerSize', 6, ...       
   'Marker', 'square'); 
else    
   line( ...       
   newCurve(1,1), ...       
   newCurve(1,2), ...       
   'Color','b', ...       
   'EraseMode','none', ...       
   'MarkerSize', 6, ...       
   'Marker', 'square'); 
end; 
