function s=mainWinButtonDownFnc(pts)  

mouseCoord = get(gca, 'CurrentPoint');
newPt = mouseCoord(1, 1:2); 
if size(pts,1) > 0    
   % normalize for now to simluate uniform parametrization    
   prevPt = pts(end, 1:2);    
   diff = newPt - prevPt;    
   newPt = prevPt + diff/norm(diff); 
end 
% append point 
s=[pts; newPt]; 
numPts = size(s,1); 
if numPts > 1    
   line( ...       
   s(numPts-1:numPts,1), ...       
   s(numPts-1:numPts,2), ...       
   'Color','b', ...       
   'EraseMode','none', ...       
   'MarkerSize', 6, ...       
   'Marker', 'square'); 
else    
   line( ...       
   s(1,1), ...       
   s(1,2), ...       
   'Color','b', ...       
   'EraseMode','none', ...       
   'MarkerSize', 6, ...       
   'Marker', 'square'); 
end; 