global c
global T

% get algorithm parameters
strLambda = get(lambda, 'String');
valLambda = str2double(strLambda);

disp(sprintf('Comparing %s and %s...', curve1name, curve2name));

% begin the fast marching method
if get(checkClosed, 'Value') == 1
    if get(radioCurvature, 'Value') == 1
        processClosedCurvature;
    else
        processClosedShapeContexts;
    end
else
    if get(radioCurvature, 'Value') == 1
        %processCurvNonSquareGrid;
        processCurvature;
    else
        processShapeContexts;
    end
end
%processShapeContNonSquareGrid;

% draw contour and gradient descent curve
set(0, 'CurrentFigure', contourViewWin);
[m, n] = size(T); 
if get(checkClosed, 'Value') == 1
	m_ = m/3;   % closed curve length
	n_ = n/2;   % closed curve length
else
    m_ = m;
    n_ = n;
end
x = zeros(m,1); x(1,1) = 1;
if get(checkClosed, 'Value') == 1
    % closed curve locations
    y = zeros(n,1); y(1,1) = 1;
	for i = 2:m,
        x(i) = x(i-1) + spacing1(i);
	end
	for j = 2:n,
        y(j) = y(j-1) + spacing2(j);
	end
    % offset the y-axis tickmarks - solve for optimal path in middle band
    % comment out to solve for optimal path in lower band
    x = x - m_;
else
    % open curve locations
    y = zeros(n,1); y(1,1) = 1;
	for i = 2:m,
        x(i) = x(i-1) + spacing1(i-1);
	end
	for j = 2:n,
        y(j) = y(j-1) + spacing2(j-1);
	end
end
c = backtrack(T, 0.1, x(m), y(n), y, x);

% draw surface
set(0, 'CurrentFigure', surfaceViewWin);
surf(y, x, T, 'LineStyle', 'none');
light('Position',[0 0 1],'Style','infinite');
material metal;

% draw contour
set(0, 'CurrentFigure', contourViewWin);
contour(y, x, T, 30);
hold on; 
line(c(1:end, 2), c(1:end, 1));
hold off;
axis equal tight;
xlabel('Curve 2');
ylabel('Curve 1');
title('Level Set Map and Gradient Descent Path');
colorbar;
if get(checkClosed, 'Value') == 1
    % closed curves
    % display just the middle horiz. band of T
    axis([1 n 1 m_]);
    disp('Press any key to continue...');
    pause;
    disp('Reparametrizing curve 2...'); 
    c_endpoint = round(c(end, 2));
    curve2_match_point = mod(c_endpoint-1, n_)+1;
    curve2new = [curve2(curve2_match_point:end, :); curve2(1:curve2_match_point-1, :)];
    curve2 = curve2new;

    % rerun open curve algorithm on reparametrized curves
    if get(radioCurvature, 'Value') == 1
        %processCurvNonSquareGrid;
        processCurvature;
    else
        processShapeContexts;
    end
    
	[m, n] = size(T); 
    % open curve locations
	x = zeros(m,1); x(1,1) = 1;
    y = zeros(n,1); y(1,1) = 1;
	for i = 2:m,
        x(i) = x(i-1) + spacing1(i-1);
	end
	for j = 2:n,
        y(j) = y(j-1) + spacing2(j-1);
	end
	c = backtrack(T, 0.1, x(m), y(n), y, x);
	
    set(0, 'CurrentFigure', contourViewWin);
	contour(y, x, T, 30);
	hold on; 
	line(c(1:end, 2), c(1:end, 1));
	hold off;
	axis equal tight;
	xlabel('Curve 2');
	ylabel('Curve 1');
	title('Level Set Map and Gradient Descent Path');
	colorbar;
    
	% draw surface
	set(0, 'CurrentFigure', surfaceViewWin);
	surf(y, x, T, 'LineStyle', 'none');
	light('Position',[0 0 1],'Style','infinite');
	material metal;
end

% compute distance
% if get(checkClosed, 'Value') == 1
%     % closed curves - take difference of T values at appropriate points
%     c_beginning = round(c(end,:));
%     T_beginning = T(m_+1, c_beginning(2));
%     % search for c_end
%     idx = size(c, 1);
%     while (idx > 0) & (floor(c(idx,1)) < m_)
%         idx = idx-1;
%     end
%     c_end = round(c(idx,:));
%     T_end = T(2*m_, c_end(2));
%     curve_distance = T_end - T_beginning;
% 	% normalize distance to compensate for curve lengths
% 	strT = curve_distance - valLambda*sqrt(m_*m_ + n_*n_) + abs(1 - min(m_,n_)/max(m_,n_));
% else
    curve_distance = T(end, end);
	% normalize distance to compensate for curve lengths
    diag_integral = valLambda*sqrt(m*m + n*n);
	strT = curve_distance - diag_integral + abs(1 - min(m,n)/max(m,n));
% end
% score report
set(resultT, 'String', strT);

% report lambda value used
set(lambda, 'String', valLambda);

% various statistics reports
F1 = F - valLambda;
sumDiffs = sum(sum(F1));
set(avgCurvDiff, 'String', sumDiffs/(m*n));
if get(radioCurvature, 'Value') == 1
	sumK1 = sum(abs(k1));
	sumK2 = sum(abs(k2));
	set(avgCurv, 'String', (sumK1 + sumK2)/(m + n));
end

% enable menus
set(MorphMenu, 'Enable', 'on');

% redraw curves coloring them according to alignment
colorCurve(curve1, 1, curve1win);
colorCurve(curve2, 2, curve2win);

% trap clicks
set(contourViewWin, 'WindowButtonDownFcn', 'selectPoint;');  

