function [curve, FILENAME] = LoadCurve(figHandle)

global CURDIR

curve = [];

% open dlg box
cd(CURDIR); 
[FILENAME, PATHNAME] = uigetfile('*.mat', 'Load Curve');
if (~ischar(PATHNAME) & PATHNAME==0) | (~ischar(FILENAME) & FILENAME==0)
    % cancel pressed
    return;
end
PATHFILENAME = strcat(PATHNAME,FILENAME);
CURDIR = PATHNAME;
	
if ~isempty(PATHFILENAME)
    % load
    load(PATHFILENAME, 'curve');

    % draw curve on figure figHandle
    numPts = size(curve,1);
    line( ...
        curve(1:numPts,1), ...
        curve(1:numPts,2), ...
        'Color','b', ...
        'EraseMode','none', ...
        'MarkerSize', 5, ...
        'Marker', 'none');
  
	axis off;
	axis tight;
	axis equal;

    set(gcf,'Name',FILENAME);
end


