function [bandNew, T] = addToBand(bandOld, T, i, j)



% append to array

elt = T(i,j,1);

bandNew = [bandOld; elt i j];



idx = size(bandNew, 1);

idxParent = floor(idx/2);

tmp = [0 0 0];



while (idxParent ~= 0) & (bandNew(idxParent,1) > bandNew(idx,1)),

   % swap parent and child

   tmp = bandNew(idx, 1:end);

   bandNew(idx, 1:end) = bandNew(idxParent, 1:end);

   bandNew(idxParent, 1:end) = tmp;

   % update band location in grid of the parent just moved 

   T(bandNew(idx, 2), bandNew(idx, 3), 2) = idx;

   % go up the heapTree

   idx = idxParent;

   idxParent = floor(idx/2);

end



% store band location in grid at i,j

T(i,j,2) = idx;

