function colorCurve(curve, colIdxInC, figID)

global T
global c

% draw curve1 
set(0, 'CurrentFigure', figID);
cla;
numPts = size(curve,1);
maxTvalue = T(end, end); 
maxColor = size(colormap, 1);
colMap = colormap;
p = size(c, 1);
% p is the location of first occurence of i in left col of c()
% coord vector at that location
firstOccur = c(p,:);    
% corresponding T value (no interpolation - just rounding)
firstOccur = round(firstOccur);
firstTValue = T(firstOccur(1), firstOccur(2)); 
for i = 1:numPts-1,
    % linearly search for the last occurence of coordinate 
    % i in t of c() = (t, s), t - curve 1 coord, s - curve 2 coord
    % continue searching for second occurence from last value of p
    while (p > 1) & (c(p, colIdxInC) < i+1),
        p=p-1;
    end
	lastOccur = c(p,:);    
	% corresponding T value (no interpolation - just rounding)
	lastOccur = round(lastOccur);
	lastTValue = T(lastOccur(1), lastOccur(2)); 
    
    % average the T values
    aveTvalue = (firstTValue + lastTValue)/2;
    
    % use average to index into current colormap
    frac = aveTvalue/maxTvalue;
    colMapIdx = round(frac*maxColor);
    if colMapIdx == 0 
        colMapIdx = 1;
    elseif colMapIdx > maxColor
        colMapIdx = maxColor;
    end
    colorValue = colMap(colMapIdx,:);
    
    % draw curve segment using computed color
    line( ...
        curve(i:i+1,1), ...
        curve(i:i+1,2), ...
        'Color', colorValue, ...
        'EraseMode','none', ...
        'MarkerSize', 2, ...
        'Marker', 'p');
    
    % reset first- data for next iteration
    firstOccur = lastOccur;
    firstTValue = lastTValue;
end

