global contourViewWin
global CURDIR
APPDIR = PWD;
CURDIR = PWD;
TRAINDIR = 'trainingSet';

%training set for recognition - list of filenames in var trainingSet
load trainingSet/train.mat;

drawCurveMode1=0;
drawCurveMode2=0;
curve1win = figure(1);
axes('Box','on',...
    'XLim',[1 40],...
    'YLim',[1 40]);
axis square;
set(curve1win, ...
    'Name', 'Curve 1', ...
    'CloseRequestFcn', ['delete(curve1win), delete(curve2win), delete(processWin),' ...
    'delete(contourViewWin), delete(surfaceViewWin)']);
%set(curve1win,'WindowButtonDownFcn','curve1 = mainWinButtonDownFnc(curve1); %drawCurveMode1=1;'); 
set(curve1win,'WindowButtonDownFcn','curve1=addFirstPoint(curve1); drawCurveMode1=1;'); 
set(curve1win,'WindowButtonUpFcn','drawCurveMode1=0;'); 
set(curve1win,'WindowButtonMotionFcn','if (drawCurveMode1==1) curve1=addPoints(curve1); end;'); 
CurveMenu1 = uimenu('Label', 'Curve');
CurveLoadMenu1 = uimenu(CurveMenu1, 'Label', 'Load...', ...
   'Callback', ['xlim = get(gca, ''XLim''); ylim = get(gca, ''YLim'');' ...
   'delete(gca), axes(''YLim'', ylim, ''XLim'', xlim, ''Box'',''on'');' ...
   'axis square; [curve1 curve1name] = LoadCurve(curve1win); cd(APPDIR);']);
CurveSaveMenu1 = uimenu(CurveMenu1, 'Label', 'Save...', ...
   'Callback', 'SaveCurve(curve1); cd(APPDIR);');
CurveClearMenu1 = uimenu(CurveMenu1, 'Label', 'Clear', ...
   'Callback', ['curve1 = []; curve1name = []; xlim = get(gca, ''XLim''); ylim = get(gca, ''YLim'');'...
   'delete(gca), axes(''YLim'', ylim, ''XLim'', xlim, ''Box'',''on''); axis square;']); 
DelPt1 = uimenu(CurveMenu1, 'Label', 'Delete Last Point', ...
   'Callback', ['xlim = get(gca, ''XLim''); ylim = get(gca, ''YLim'');' ...
   'delete(gca), axes(''YLim'', ylim, ''XLim'', xlim, ''Box'',''on'');' ...
   'axis square; curve1 = DeletePoint(curve1);']);  
MorphMenu = uimenu(CurveMenu1, 'Label', 'Morph into Curve2...', ...
   'Callback', 'Morph1To2;');
set(MorphMenu, 'Enable', 'off');
LearnMenu = uimenu(CurveMenu1, 'Label', 'Learn...', ...
   'Callback', 'LearnCurve;');
RecognizeMenu = uimenu(CurveMenu1, 'Label', 'Recognize...', ...
   'Callback', 'RecognizeCurve;');

curve2win = figure(2); 
axes('Box','on',...
    'XLim',[1 40],...
    'YLim',[1 40]);
axis square;
set(curve2win, ...
    'Name', 'Curve 2', ...
    'CloseRequestFcn', ['delete(curve1win), delete(curve2win),' ...
    'delete(processWin), delete(contourViewWin), delete(surfaceViewWin)']);
%set(curve2win,'WindowButtonDownFcn','curve2 = mainWinButtonDownFnc(curve2); %drawCurveMode2=1;'); 
set(curve2win,'WindowButtonDownFcn','curve2=addFirstPoint(curve2); drawCurveMode2=1;'); 
set(curve2win,'WindowButtonUpFcn','drawCurveMode2=0;'); 
set(curve2win,'WindowButtonMotionFcn','if (drawCurveMode2==1) curve2=addPoints(curve2); end;'); 
CurveMenu2 = uimenu('Label', 'Curve'); 
CurveLoadMenu2 = uimenu(CurveMenu2, 'Label', 'Load...', ...
   'Callback', ['xlim = get(gca, ''XLim''); ylim = get(gca, ''YLim''); delete(gca),' ...
   'axes(''YLim'', ylim, ''XLim'', xlim, ''Box'',''on'');' ...
   'axis square; [curve2 curve2name] = LoadCurve(curve2win); cd(APPDIR);']); 
CurveSaveMenu2 = uimenu(CurveMenu2, 'Label', 'Save...', ...
   'Callback', 'SaveCurve(curve2); cd(APPDIR);'); 
CurveClearMenu2 = uimenu(CurveMenu2, 'Label', 'Clear', ...
   'Callback', ['curve2 = []; curve2name = []; xlim = get(gca, ''XLim''); ylim = get(gca, ''YLim'');' ...
   'delete(gca), axes(''YLim'', ylim, ''XLim'', xlim, ''Box'',''on''); axis square;']);  
uimenu(CurveMenu2, 'Label', 'Delete Last Point', ...
   'Callback', ['xlim = get(gca, ''XLim''); ylim = get(gca, ''YLim'');' ...
   'delete(gca), axes(''YLim'', ylim, ''XLim'', xlim, ''Box'',''on'');' ...
   'axis square; curve2 = DeletePoint(curve2);']);

curve1 = []; curve2 = [];  
c = [];
curve1name = [];
curve2name = [];

% processing window 
processWin = open('figs/processWin.fig');
lambda = findobj('Tag', 'lambda');
resultT = findobj('Tag', 'distanceResult');
viewNormals = findobj('String', 'View contour normals');
avgCurv = findobj('Tag', 'avgCurvature');
avgCurvDiff = findobj('Tag', 'avgCurvDiff');
radioCurvature = findobj('Tag', 'radiobutton1_curvature');
radioShapeContexts = findobj('Tag', 'radiobutton2_shape_contexts');
avgCurvDiff = findobj('Tag', 'avgCurvDiff');
checkClosed = findobj('Tag', 'checkbox2_closed_curves');
checkAutoLambda = findobj('Tag', 'checkboxAutomatic');
% diss func radio buttons
set(radioCurvature, 'Callback', ['if get(radioShapeContexts, ''Value'') == 1' ...
    'set(radioShapeContexts, ''Value'', 0); end']);
set(radioShapeContexts, 'Callback', ['if get(radioCurvature, ''Value'') == 1' ...
    'set(radioCurvature, ''Value'', 0); end']);

% Contour view window 
contourViewWin = figure(4); 
set(contourViewWin, ...
    'Name', 'Contour View', ...
    'CloseRequestFcn', ['delete(curve1win), delete(curve2win),' ...
    'delete(processWin), delete(contourViewWin), delete(surfaceViewWin)']);  
axesProcessWin = axes('Box','on');  
viewContour = findobj('String', 'View contour');
if get(viewContour, 'Value') == 1
    set(contourViewWin, 'Visible', 'on');
else
    set(contourViewWin, 'Visible', 'off');
end

% Surface view window 
surfaceViewWin = figure(5); 
set(surfaceViewWin, ...
    'Name', 'Surface View', ...
    'CloseRequestFcn', ['delete(curve1win), delete(curve2win),' ...
    'delete(processWin), delete(contourViewWin), delete(surfaceViewWin)']);  
axes('Box','on'); 
viewSurface = findobj('String', 'View surface');
if get(viewSurface, 'Value') == 1
    set(surfaceViewWin, 'Visible', 'on');
else
    set(surfaceViewWin, 'Visible', 'off');
end

