D = dir;

% filenames start at 3
for j=3:size(D,1),
    name = D(j).name;

    length = size(name,2);
    % check extension
    if(strcmp(name(length-3:length), '.mat')==0)
        continue;
    end
        
	% load
	load(name, 'curve');
	
	% draw curve on figure figHandle
	numPts = size(curve,1);
    delete(gca);
    axes;
	line( ...
      curve(1:numPts,1), ...
      curve(1:numPts,2), ...
      'Color','b', ...
      'EraseMode','none', ...
      'MarkerSize', 6, ...
      'Marker', 'none');
    % fill in hole
	line( ...
      [curve(1,1) curve(end,1)], ...
      [curve(1,2) curve(end,2)], ...
      'Color','b', ...
      'EraseMode','none', ...
      'MarkerSize', 6, ...
      'Marker', 'none');
	
	axis off;
	axis tight;
	axis equal;
	
	set(gcf, 'Name', name);

    epsfilename = name(1:length-4);
    extention = '.eps';
    epsfilename = strcat(epsfilename, extention);
    print('-depsc', epsfilename);
end
cd ..