function [bandNew, T] = getFromBand(bandNew, T)

sizeBandOld = size(bandNew,1);
if sizeBandOld == 0
    return
end

idxParent = 1;
idxParentOld = 1;
idxLeftChild = 3;
idxRightChild = 2;

%bandNew = bandOld;

% go down making sure that the heap property is valid for all children
while (idxLeftChild <= sizeBandOld),
    idxParentOld = idxParent;
    if bandNew(idxRightChild, 1) < bandNew(idxLeftChild, 1)
        bandNew(idxParent, 1:end) = bandNew(idxRightChild, 1:end);
        % update band location in grid of the child just moved 
        T(bandNew(idxParent, 2), bandNew(idxParent, 3), 2) = idxParent;
        idxParent = idxRightChild;
    else
        bandNew(idxParent, 1:end) = bandNew(idxLeftChild, 1:end);
        % update band location in grid of the child just moved 
        T(bandNew(idxParent, 2), bandNew(idxParent, 3), 2) = idxParent;
        idxParent = idxLeftChild;
    end
    idxLeftChild = 2*idxParent + 1;
    idxRightChild = 2*idxParent;
end

if idxRightChild == sizeBandOld
    bandNew(idxParent, 1:end) = bandNew(idxRightChild, 1:end);
    % update band location in grid of the child just moved 
    T(bandNew(idxParent, 2), bandNew(idxParent, 3), 2) = idxParent;
    % clip right child (last in heap)
    bandNew = bandNew(1:end-1, 1:end); 
    return
end   

if idxParent < sizeBandOld
    % make left child the right child of parent
    bandNew(idxParent, 1:end) = bandNew(sizeBandOld, 1:end);   
    % update band location in grid of the child just moved 
    T(bandNew(idxParent, 2), bandNew(idxParent, 3), 2) = idxParent;
end

% clip left child (last in heap)
bandNew = bandNew(1:end-1, 1:end); 
