% ititialization of the FMM from given curves
% lambda is the stretch parameter
function T = processClosed(curve1, curve2, lambda)

m = size(curve1, 1)-2;
n = size(curve2, 1)-2;
CURVATURE_THRESHOLD = 0.08;

% compute curvatures k1, k2 (disregard endpoints)
k1 = zeros(m,1);
k2 = zeros(n,1);
for i=1:m,
    delX = curve1(i+2, 1) - curve1(i, 1);
    delY = curve1(i+2, 2) - curve1(i, 2);
    k1(i) = 4*( (curve1(i+2, 2) - 2*curve1(i+1, 2) + curve1(i, 2))*delX - ...
        (curve1(i+2, 1) - 2*curve1(i+1, 1) + curve1(i, 1))*delY ) /...
        (delX*delX + delY*delY)^(3/2);
    %   k1(i) = norm(curve1(i, 1:2) - 2*curve1(i+1, 1:2) + curve1(i+2, 1:2));
    %   if k1(i) > CURVATURE_THRESHOLD
    %       k1(i) = 0;
    %   end
end

for i=1:n,
    delX = curve2(i+2, 1) - curve2(i, 1);
    delY = curve2(i+2, 2) - curve2(i, 2);
    k2(i) = 4*( (curve2(i+2, 2) - 2*curve2(i+1, 2) + curve2(i, 2))*delX - ...
        (curve2(i+2, 1) - 2*curve2(i+1, 1) + curve2(i, 1))*delY ) /...
        (delX*delX + delY*delY)^(3/2);
    %   k2(i) = norm(curve2(i, 1:2) - 2*curve2(i+1, 1:2) + curve2(i+2, 1:2));
    %   if k2(i) > CURVATURE_THRESHOLD
    %       k2(i) = 0;
    %   end
end

% assumes closed curves as input
k2 = [k2 k2];

% compute the speed function F
F = [];
SMALL = 0.0001;
% dtds = abs(m - n)/(m + n);
for i=1:m,
    for j=1:(2*n),
        %       if (k2(j) + k1(i)) > SMALL,
        F(i,j) = abs(k2(j) - k1(i)) + lambda;
        %        else
        %            % both curvatures are zero
        %            F(i,j) = lambda;
        %        end
    end
end

%contour(F);

% start points - a line of zeros along curve 2 axis
initSet = [1 1];
for i = 2:n,
    initSet = [initSet; 1 i];
end

% begin
T = FMM(initSet, F);