%function selectPoint(curve1win, curve2win, curve1, curve2)

% get selected point
mouseCoord = get(gca, 'CurrentPoint');
selectedPt = mouseCoord(1, 1:2); 
% endpoints are discarded
selectedPt = selectedPt+1;

% boundary check
if get(checkClosed, 'Value') == 1
    % closed curves - wrap around curve2
    c1Len = m;%size(curve1,1);
    c2Len = n;
else
    c1Len = size(curve1,1);
    c2Len = size(curve2,1);
end
if (selectedPt >= [1 1]) & (selectedPt < [c2Len c1Len]),

    cla;
	contour(y, x, T, 30);
	hold on; 
	line(c(1:end, 2), c(1:end, 1));
	hold off;
	axis equal tight;
	xlabel('Curve 2');
	ylabel('Curve 1');
	title('Level Set Map and Gradient Descent Path');
	colorbar;
	if get(checkClosed, 'Value') == 1
        % closed curves
         % display just the middle horiz. band of T
%        axis([1 n 1 m_]);
	%    contour(y, x(1:m_), T(m_+1:2*m_+1, :), 30);
	end
    % mark selected point on contour view axes
    line(selectedPt(1)-1, selectedPt(2)-1, 'Color', 'k', 'Marker', '>', 'MarkerSize', 8);
        
	% get axes
	axes1 = get(curve1win, 'CurrentAxes');
	axes2 = get(curve2win, 'CurrentAxes');
	
	flPt = floor(selectedPt);
	rem = selectedPt - flPt;
	set(0,'CurrentFigure', curve1win);
    % redraw curve
    colorCurve(curve1, 1, curve1win);
	% draw current selected point (it is between two points of the curve)
	line( ...
        (1 - rem(2))*curve1(flPt(2), 1) + rem(2)*curve1(flPt(2)+1, 1), ...
        (1 - rem(2))*curve1(flPt(2), 2) + rem(2)*curve1(flPt(2)+1, 2), ...
        'Color','k', ...
        'Marker', '>', 'MarkerSize', 8);

	set(0,'CurrentFigure', curve2win);
    colorCurve(curve2, 2, curve2win);
    % wrap-around trick for closed curves (no change in case of open curves)
    flPt(1) = mod(flPt(1), n_);
    first_point = flPt(1);
    second_point = flPt(1)+1;
    if flPt(1) == 0
        % end-beginning connection
        first_point = n_;
        second_point = 1;
    end
	line( ...
        (1 - rem(1))*curve2(first_point, 1) + rem(1)*curve2(second_point, 1), ...
        (1 - rem(1))*curve2(first_point, 2) + rem(1)*curve2(second_point, 2), ...
        'Color','k', ...
        'Marker', '>', 'MarkerSize', 8);
end % end if within boundaries

