function Tnew = solveQuadraticNonSquareGrid(T, F, i, j, m, n, spacing1, spacing2)

% determine which derivative approximation is maximal - forwards or backwards
if i == 1
	if j == 1
		% solve using forward i and forward j
        Tnew = updateTNonSquareGrid(F(1, 1), spacing1(1), spacing2(1), T(2, 1, 1), T(1, 2, 1));
	elseif j == n
		% solve using forward i and backward j
        Tnew = updateTNonSquareGrid(F(1, n), spacing1(1), spacing2(n-1), T(2, n, 1), T(1, n-1, 1));
    else
		% solve using forward i and 
        % try both forwards j and backwards j taking minimum result
        TnewForw_j = updateTNonSquareGrid(F(1, j), spacing1(1), spacing2(j), T(2, j, 1), T(1, j+1, 1));
        TnewBackw_j = updateTNonSquareGrid(F(1, j), spacing1(1), spacing2(j-1), T(2, j, 1), T(1, j-1, 1));
        Tnew = min(TnewForw_j, TnewBackw_j);
	end
elseif i == m
	if j == 1
		% solve using backward i and forward j
        Tnew = updateTNonSquareGrid(F(m, 1), spacing1(m-1), spacing2(1), T(m-1, 1, 1), T(m, 2, 1));
	elseif j == n
		% solve using backward i and backward j
        Tnew = updateTNonSquareGrid(F(m, n), spacing1(m-1), spacing2(n-1), T(m-1, n, 1), T(m, n-1, 1));
    else
		% solve using backward i and 
        % try both forwards j and backwards j taking minimum result
        TnewForw_j = updateTNonSquareGrid(F(m, j), spacing1(m-1), spacing2(j), T(m-1, j, 1), T(m, j+1, 1));
        TnewBackw_j = updateTNonSquareGrid(F(m, j), spacing1(m-1), spacing2(j-1), T(m-1, j, 1), T(m, j-1, 1));
        Tnew = min(TnewForw_j, TnewBackw_j);
	end
else
	if j == 1
		% solve using forward j and 
        % try both forwards i and backwards i taking minimum result
        TnewForw_i = updateTNonSquareGrid(F(i, 1), spacing1(i), spacing2(1), T(i+1, 1, 1), T(i, 2, 1));
        TnewBackw_i = updateTNonSquareGrid(F(i, 1), spacing1(i-1), spacing2(1), T(i-1, 1, 1), T(i, 2, 1));
        Tnew = min(TnewForw_i, TnewBackw_i);
	elseif j == n
		% solve using  backward j and
        % try both forwards i and backwards i taking minimum result
        TnewForw_i = updateTNonSquareGrid(F(i, n), spacing1(i), spacing2(n-1), T(i+1, n, 1), T(i, n-1, 1));
        TnewBackw_i = updateTNonSquareGrid(F(i, n), spacing1(i-1), spacing2(n-1), T(i-1, n, 1), T(i, n-1, 1));
        Tnew = min(TnewForw_i, TnewBackw_i);
    else
		% try both forwards i and backwards i taking minimum result
        % try both forwards j and backwards j taking minimum result
        TnewForw_i_Forw_j = updateTNonSquareGrid(F(i, j), spacing1(i), spacing2(j), T(i+1, j, 1), T(i, j+1, 1));
        TnewBackw_i_Forw_j = updateTNonSquareGrid(F(i, j), spacing1(i-1), spacing2(j), T(i-1, j, 1), T(i, j+1, 1));
        TnewForw_i_Backw_j = updateTNonSquareGrid(F(i, j), spacing1(i), spacing2(j-1), T(i+1, j, 1), T(i, j-1, 1));
        TnewBackw_i_Backw_j = updateTNonSquareGrid(F(i, j), spacing1(i-1), spacing2(j-1), T(i-1, j, 1), T(i, j-1, 1));
        Tnew = min([TnewForw_i_Forw_j TnewBackw_i_Forw_j TnewForw_i_Backw_j TnewBackw_i_Backw_j]);
	end
end

