function Tnew = solveQuadraticSecondOrder(T, F, i, j, m, n)

global HUGE

% backwards i direction switch
if i>2 & (T(i-2, j, 1) ~= HUGE) & (T(i-1, j, 1) ~= HUGE) & ...
        (T(i-2, j, 1) <= T(i-1, j, 1))
    Tbiknown = 4*T(i-1, j, 1) - T(i-2, j, 1);
    bi2nd = 1;
else
    bi2nd = 0;    
end
% backwards j direction switch
if j>2 & (T(i, j-2, 1) ~= HUGE) & (T(i, j-1, 1) ~= HUGE) & ...
        (T(i, j-2, 1) <= T(i, j-1, 1))
    Tbjknown = 4*T(i, j-1, 1) - T(i, j-2, 1);
    bj2nd = 1;
else
    bj2nd = 0;    
end
% forwards i direction switch
if i<m-1 & (T(i+2, j, 1) ~= HUGE) & (T(i+1, j, 1) ~= HUGE) & ...
        (T(i+2, j, 1) <= T(i+1, j, 1))
    Tfiknown = 4*T(i+1, j, 1) - T(i+2, j, 1);
    fi2nd = 1;
else
    fi2nd = 0;    
end
% forwards j direction switch
if j<n-1 & (T(i, j+2, 1) ~= HUGE) & (T(i, j+1, 1) ~= HUGE) & ...
        (T(i, j+2, 1) <= T(i, j+1, 1))
    Tfjknown = 4*T(i, j+1, 1) - T(i, j+2, 1);    
    fj2nd = 1;
else
    fj2nd = 0;    
end

if bi2nd
    if fi2nd
        % both 2nd order in i direction
        Ti = min(Tbiknown, Tfiknown);
        if bj2nd
            if fj2nd
                % all four 2nd order (rare)
                % use smaller of Tbjknown or Tfjknown
                Tnew = solveBoth2ndOrder(Ti, min(Tbjknown, Tfjknown), F(i,j));
            else
                % either use Tbjknown or forward j 1st order difference
                if j==n | (j<n & (Tbjknown <= 3*T(i, j+1, 1)))
                    % use Tbjknown
                    Tnew = solveBoth2ndOrder(Ti, Tbjknown, F(i,j));
                else
                    % use 1st order j forward difference
                    Tnew = solve1stOrderAnd2ndOrder(T(i, j+1, 1), Ti, F(i,j));
                end
            end
        else
            if fj2nd
                % either use Tfjknown or backward j 1st order difference
                if j==1 | (j>1 & (Tfjknown <= 3*T(i, j-1, 1)))
                    % use Tfjknown
                    Tnew = solveBoth2ndOrder(Ti, Tfjknown, F(i,j));
                else
                    % use 1st order j forward difference
                    Tnew = solve1stOrderAnd2ndOrder(T(i, j+1, 1), Ti, F(i,j));
                end
            else
                % either use forward or backward j 1st order difference
				if j == 1
                    Tj = T(i, j+1, 1);
				elseif j == n
                    Tj = T(i, j-1, 1);
				else
                    Tj = min(T(i, j+1, 1), T(i, j-1, 1));
				end
                Tnew = solve1stOrderAnd2ndOrder(Tj, Ti, F(i,j));
            end
        end
    else    % if fi2nd
        % either use Tbiknown or forward i 1st order difference
        if i==m | (i<m & (Tbiknown <= 3*T(i+1, j, 1)))
            % use Tbiknown - 2nd order i backward
            if bj2nd
                if fj2nd
                    Tnew = solveBoth2ndOrder(Tbiknown, min(Tbjknown, Tfjknown), F(i,j));
                else
                    % either use Tbjknown or forward j 1st order difference
                    if j==n | (j<n & (Tbjknown <= 3*T(i, j+1, 1)))
                        % use Tbjknown
                        Tnew = solveBoth2ndOrder(Tbiknown, Tbjknown, F(i,j));
                    else
                        % use 1st order j forward difference
                        Tnew = solve1stOrderAnd2ndOrder(T(i, j+1, 1), Tbiknown, F(i,j));
                    end
                end
            else    % if bj2nd
                if fj2nd
                    % either use Tfjknown or backward j 1st order difference
                    if j==1 | (j>1 & (Tfjknown <= 3*T(i, j-1, 1)))
                        % use Tfjknown
                        Tnew = solveBoth2ndOrder(Tbiknown, Tfjknown, F(i,j));
                    else
                        % use 1st order j backward difference
                        Tnew = solve1stOrderAnd2ndOrder(T(i, j-1, 1), Tbiknown, F(i,j));
                    end
                else
                    % either use forward or backward j 1st order difference
					if j == 1
                        Tj = T(i, j+1, 1);
					elseif j == n
                        Tj = T(i, j-1, 1);
					else
                        Tj = min(T(i, j+1, 1), T(i, j-1, 1));
					end
                    Tnew = solve1stOrderAnd2ndOrder(Tj, Tbiknown, F(i,j));
                end            
            end
        else    % if i==m | (i<m & (Tbiknown <= 3*T(i+1, j, 1)))
            % use 1st order i forward difference
            if bj2nd
                if fj2nd
                    % choose min of 2nd order j differences
                    Tnew = solve1stOrderAnd2ndOrder(T(i+1, j, 1), min(Tbjknown, Tfjknown), F(i,j));
                else
                    % either use Tbjknown or forward j 1st order difference
                    if j==n | (j<n & (Tbjknown <= 3*T(i, j+1, 1)))
                        % use Tbjknown
                        Tnew = solve1stOrderAnd2ndOrder(T(i+1, j, 1), Tbjknown, F(i,j));
                    else
                        % use 1st order j forward difference (both 1st order now)
                        Tnew = solveBoth1stOrder(T(i, j+1, 1), T(i+1, j, 1), F(i,j));
                    end
                end
            else
                if fj2nd
                    % either use Tfjknown or backward j 1st order difference
                    if j==1 | (j>1 & (Tfjknown <= 3*T(i, j-1, 1)))
                        % use Tfjknown
                        Tnew = solve1stOrderAnd2ndOrder(T(i+1, j, 1), Tfjknown, F(i,j));
                    else
                        % use 1st order j backward difference
                        Tnew = solveBoth1stOrder(T(i, j-1, 1), T(i+1, j, 1), F(i,j));
                    end
                else
                    % either use forward or backward j 1st order difference
					if j == 1
                        Tj = T(i, j+1, 1);
					elseif j == n
                        Tj = T(i, j-1, 1);
					else
                        Tj = min(T(i, j+1, 1), T(i, j-1, 1));
					end
                    Tnew = solveBoth1stOrder(Tj, T(i+1, j, 1), F(i,j));
                end                            
            end
        end
    end
else    % if bi2nd - 2nd order backward i unavailable
    if fi2nd
        % either use fi2nd or biFirst
        if i==1 | (i>1 & (Tfiknown <= 3*T(i-1, j, 1)))
            % use Tfiknown
            if bj2nd
                if fj2nd
                    Tnew = solveBoth2ndOrder(Tfiknown, min(Tbjknown, Tfjknown), F(i,j));
                else
                    % either use Tbjknown or forward j 1st order difference
                    if j==n | (j<n & (Tbjknown <= 3*T(i, j+1, 1)))
                        % use Tbjknown
                        Tnew = solveBoth2ndOrder(Tfiknown, Tbjknown, F(i,j));
                    else
                        % use 1st order j forward difference
                        Tnew = solve1stOrderAnd2ndOrder(T(i, j+1, 1), Tfiknown, F(i,j));
                    end
                end
            else    % if bj2nd
                if fj2nd
                    % either use Tfjknown or backward j 1st order difference
                    if j==1 | (j>1 & (Tfjknown <= 3*T(i, j-1, 1)))
                        % use Tfjknown
                        Tnew = solveBoth2ndOrder(Tfiknown, Tfjknown, F(i,j));
                    else
                        % use 1st order j backward difference
                        Tnew = solve1stOrderAnd2ndOrder(T(i, j-1, 1), Tfiknown, F(i,j));
                    end
                else
                    % either use forward or backward j 1st order difference
					if j == 1
                        Tj = T(i, j+1, 1);
					elseif j == n
                        Tj = T(i, j-1, 1);
					else
                        Tj = min(T(i, j+1, 1), T(i, j-1, 1));
					end
                    Tnew = solve1stOrderAnd2ndOrder(Tj, Tfiknown, F(i,j));
                end            
            end
        else    % if i==1 | (i>1 & (Tfiknown <= 3*T(i-1, j, 1)))
            % use biFirst
            if bj2nd
                if fj2nd
                    % choose min of 2nd order j differences
                    Tnew = solve1stOrderAnd2ndOrder(T(i-1, j, 1), min(Tbjknown, Tfjknown), F(i,j));
                else
                    % either use Tbjknown or forward j 1st order difference
                    if j==n | (j<n & (Tbjknown <= 3*T(i, j+1, 1)))
                        % use Tbjknown
                        Tnew = solve1stOrderAnd2ndOrder(T(i-1, j, 1), Tbjknown, F(i,j));
                    else
                        % use 1st order j forward difference (both 1st order now)
                        Tnew = solveBoth1stOrder(T(i, j+1, 1), T(i-1, j, 1), F(i,j));
                    end
                end
            else
                if fj2nd
                    % either use Tfjknown or backward j 1st order difference
                    if j==1 | (j>1 & (Tfjknown <= 3*T(i, j-1, 1)))
                        % use Tfjknown
                        Tnew = solve1stOrderAnd2ndOrder(T(i-1, j, 1), Tfjknown, F(i,j));
                    else
                        % use 1st order j backward difference
                        Tnew = solveBoth1stOrder(T(i, j-1, 1), T(i-1, j, 1), F(i,j));
                    end
                else
                    % either use forward or backward j 1st order difference
					if j == 1
                        Tj = T(i, j+1, 1);
					elseif j == n
                        Tj = T(i, j-1, 1);
					else
                        Tj = min(T(i, j+1, 1), T(i, j-1, 1));
					end
                    Tnew = solveBoth1stOrder(Tj, T(i-1, j, 1), F(i,j));
                end                            
            end
        end
    else    % if fi2nd 
        % either use fiFirst or biFirst
		if i == 1
            Ti = T(i+1, j, 1);
		elseif i == m
            Ti = T(i-1, j, 1);
		else
            Ti = min(T(i+1, j, 1), T(i-1, j, 1));
		end
        if bj2nd
            if fj2nd
                % choose min of 2nd order j differences
                Tnew = solve1stOrderAnd2ndOrder(Ti, min(Tbjknown, Tfjknown), F(i,j));
            else
                % either use Tbjknown or forward j 1st order difference
                if j==n | (j<n & (Tbjknown <= 3*T(i, j+1, 1)))
                    % use Tbjknown
                    Tnew = solve1stOrderAnd2ndOrder(Ti, Tbjknown, F(i,j));
                else
                    % use 1st order j forward difference (both 1st order now)
                    Tnew = solveBoth1stOrder(T(i, j+1, 1), Ti, F(i,j));
                end
            end
        else
            if fj2nd
                % either use Tfjknown or backward j 1st order difference
                if j==1 | (j>1 & (Tfjknown <= 3*T(i, j-1, 1)))
                    % use Tfjknown
                    Tnew = solve1stOrderAnd2ndOrder(Ti, Tfjknown, F(i,j));
                else
                    % use 1st order j backward difference
                    Tnew = solveBoth1stOrder(T(i, j-1, 1), Ti, F(i,j));
                end
            else
                % either use forward or backward j 1st order difference
				if j == 1
                    Tj = T(i, j+1, 1);
				elseif j == n
                    Tj = T(i, j-1, 1);
				else
                    Tj = min(T(i, j+1, 1), T(i, j-1, 1));
				end
                Tnew = solveBoth1stOrder(Tj, Ti, F(i,j));
            end                            
        end
    end
end
        