function [band, T] = updateNode(band, T, F, idx, m, n)

i = band(idx, 2);
j = band(idx, 3);

% update value
%band = bandOld;
band(idx, 1) = solveQuadraticSecondOrder(T, F, i, j, m, n);
T(i, j, 1) = band(idx, 1);

idxParent = floor(idx/2);
tmp = [0 0 0];

while (idxParent ~= 0) & (band(idxParent,1) > band(idx,1)),
   % swap parent and child
   tmp = band(idx, 1:end);
   band(idx, 1:end) = band(idxParent, 1:end);
   band(idxParent, 1:end) = tmp;
   % update band location in grid of the parent just moved
   T(band(idx, 2), band(idx, 3), 2) = idx;
   % go up the heapTree
   idx = idxParent;
   idxParent = floor(idx/2);
end

% store band location in grid at i,j
T(i,j,2) = idx;
