function [im1, NW,SE]=shift(im, sh)
% [shifted image, north-west, south-east ] ...
%   = SHIFT(initial image, shift vector)
% Move image window by the shift vector
% Returns new image and relevant area (for comparison)

shCR=sh([2 1]); % x - Row direction, y - Column
sh_int=floor(shCR); sh_fr=shCR-sh_int; % sh_fr is non-negative

% integer shift
sh_p=max(0,sh_int); sh_n=min(0,sh_int);
im1=im(1+sh_p(1):end+sh_n(1), 1+sh_p(2):end+sh_n(2));

% subpixel shift - bilinear interpolation
im1=conv2([sh_fr(1) 1-sh_fr(1)],...
   [sh_fr(2) 1-sh_fr(2)], im1, 'valid');

% relevant area in the shifted image
NW=1-sh_n; 
SE=NW+size(im1)-1;